<?php
function getAuthorsByDomain($domain) {
    $firstNames = ["Иван", "Сергей", "Алексей", "Дмитрий", "Михаил", "Николай", "Андрей", "Евгений"];
    $lastNames  = ["Петров", "Иванов", "Сидоров", "Кузнецов", "Смирнов", "Фёдоров", "Алексеев", "Морозов"];

    $hash = crc32($domain);

    $author = $firstNames[($hash + 1) % count($firstNames)] . ' ' . $lastNames[($hash + 2) % count($lastNames)];
    $editor = $firstNames[($hash + 3) % count($firstNames)] . ' ' . $lastNames[($hash + 4) % count($lastNames)];
    $contributor = $firstNames[($hash + 5) % count($firstNames)] . ' ' . $lastNames[($hash + 6) % count($lastNames)];

    return [
        'author' => $author,
        'editor' => $editor,
        'contributor' => $contributor
    ];
}
