<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package mainfin
 */

get_header();
?>


<!-- /*************************************/ -->
<section class="credit-cards-sec">
    <div class="container">
        <h1><?php the_field('primushestva_title','option'); ?></h1>
        <div class="credit-cards-rel">
            <div class="swiper credit-cards-slider">
                <div class="swiper-wrapper">
                   <?php if( have_rows('primushestva_repeater','option') ): ?>
					<?php while( have_rows('primushestva_repeater','option') ): the_row(); ?>
					<div class="swiper-slide">
                        <div class="credit-cards-box">
                            <img src="<?php the_sub_field('primushestva_repeater_icon','option'); ?>" alt="<?php the_sub_field('primushestva_repeater_title','option'); ?>">
                            <strong><?php the_sub_field('primushestva_repeater_title','option'); ?></strong>
                            <p><?php the_sub_field('primushestva_repeater_text','option'); ?></p>
                        </div>
                    </div>	
					<?php endwhile; ?>
				<?php endif; ?>

                </div>
            </div>
            <div class="credit-button-prev swiper-button-prev"></div>
            <div class="credit-button-next swiper-button-next"></div>
        </div>
    </div>
</section>

<section class="credit-rating-sec" id="reting">
    <div class="container">
        <div class="credit-rating-text">
            <h2>Рейтинг кредитных карт</h2>
            <small>Обновлено <?php echo date('d.m.Y'); ?> </small>
        </div> 
        <div class="credit-rating-block">
			
			 <?php 
                    $args = array( 
                        'post_type' => 'list',  
                        'posts_per_page' => -1,
                    ); 
                    $query = new WP_Query( $args ); 
                    if ( $query->have_posts() ) { 
                    while ( $query->have_posts() ) { 
                    $query->the_post(); ?>
                 <div class="credit-rating-box">
					<div class="credit-rating-pic">
						<img src="<?php echo get_the_post_thumbnail_url(); ?>" alt="<?php the_title(); ?>">
						<div class="credit-rating-title">
							<strong><?php the_title(); ?></strong>
							<p><?php the_field('name_bank'); ?></p>
							<small>Лицензия № <?php the_field('number_licenzion'); ?></small>
						</div>
					</div>
					<div class="grace-period-flex">
						<div class="grace-period-name">
							<small>Льготный период</small>
							<strong><?php the_field('ligodni_period'); ?></strong>
						</div>
						<div class="grace-period-name">
							<small>Кредитный лимит</small>
							<strong><?php the_field('cridit_limite'); ?></strong>
						</div>
						<div class="grace-period-name">
							<small>Обслуживание</small>
							<strong><?php the_field('obslujivanya'); ?></strong>
						</div>
					</div>
					<div class="credit-rating-btn">
						<a target="_blank" href="<?php the_field('url'); ?>" class="btn-yellow">Оформить</a>
						<small><?php the_field('colvzayavki'); ?> </small>
					</div>
				</div> 
                    
               <?php } wp_reset_postdata(); } ?>
			
			

                                
        </div>
    </div>
</section>

<section class="reviews-sec" id="otzivy">
    <div class="container">
        <div class="reviews-title">
            <h2>Отзывы</h2>
<!--             <a href="#">Все отзывы</a> -->
        </div>
        <div class="reviews-rel">
            <div class="swiper reviews-slider">
                <div class="swiper-wrapper">
					<?php if( have_rows('otzivy_repeater','option') ): ?>
						<?php while( have_rows('otzivy_repeater','option') ): the_row(); ?>
						 <div class="swiper-slide">
							<div class="reviews-box">
								<h3><?php the_sub_field('otzivy_repeater_title','option'); ?></h3>
								<div class="reviews-star">
									<span><i class="icon-star"></i></span>
									<small><?php the_sub_field('otzivy_repeater_reting','option'); ?></small>
								</div>
								<p>
									<?php the_sub_field('otzivy_repeater_text','option'); ?>
								</p>
								<span><?php the_sub_field('otzivy_repeater_data','option'); ?></span>
							</div>
						</div>	
						<?php endwhile; ?>
					<?php endif; ?> 
                   
                </div>
            </div>
            <div class="reviews-button-prev swiper-button-prev"></div>
            <div class="reviews-button-next swiper-button-next"></div>
        </div>
    </div>
</section>

 <?php get_template_part( 'template-parts/random-content' ); ?>

<section class="profitable-sec" id="karty">
    <div class="container">
        <div class="profitable-info">
            <h1>
				<?php the_title(); ?>
			</h1>
			<?php the_field('box_seo'); ?>
			<?php the_content(); ?>
	<!--    <div class="profitable-block">
                <div class="profitable-tab">
                    <p>Наименование карты</p>
                    <span>Кредитный лимит</span>
                </div>
                <div class="profitable-tab">
                    <p>Кредитная карта «Все что надо» от банка Открытие</p>
                    <span>до 1 500 000 ₽</span>
                </div>
                <div class="profitable-tab">
                    <p>Кредитная карта Целый год без процентов Platinum от Альфа-Банка</p>
                    <span>от 5 000 до 1 000 000 ₽</span>
                </div>
            </div> -->
        </div>
    </div>
</section>
<?php

get_footer();
